--[[
	Bongos Quests
		quest timer bar
--]]

local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local Timer = Bongos:NewModule('QuestTimer')
local Quests = Bongos:GetModule('Quests')


--[[ Startup ]]--

function Timer:Load()
	local defaults = {
		point = "TOPRIGHT",
		y = -181,
		x = -14,
	}

	self.bar, isNew = Quests:CreateBar('quest timer', defaults, nil, 'MEDIUM')
	if isNew then
		self.LoadBar(self.bar)
	end
end

function Timer:Unload()
	self.bar:Destroy()
end

function Timer:LoadBar()
	for k,v in pairs(Timer) do self[k] = v end
	
	QuestTimerFrame:ClearAllPoints()
	QuestTimerFrame:SetPoint('TOPRIGHT', self, 'TOPRIGHT', 0, -12)
	
	self:Attach(QuestTimerFrame)
	self:Hook('QuestTimerFrame_Update', 'UpdateSize')
end


--[[ Size Update ]]--

function Timer:UpdateSize()
	if QuestTimerFrame:IsShown() or not Bongos:IsLocked() then
		self:SetHeight(QuestTimerFrame:GetHeight() + 12)
		self:SetWidth(QuestTimerFrame:GetWidth())
	else
		self:SetHeight(0.1)
		self:SetWidth(0.1)
	end
end